/**********
* File: CDGL_IDirect3DBaseTexture9.h

* Brief Description: This file contains the declaration of the class CDGL_IDirect3DBaseTexture9. 
					 This class is our concrete implementation of IDirect3DBaseTexture9 interface in Direct3D9. The class IDirect3DBaseTexture9 is made as an abstract class in d3d9.h (DXInclude)file.

* Written By: Shilpa Prabhu

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 08Nov04

* Change History (Most Recent First):

**********/

#ifndef __CDGL_IDIRECT3DBASETEXTURE9_H__
#define __CDGL_IDIRECT3DBASETEXTURE9_H__

#include <Carbon/Carbon.h>

#include "d3d9.h"

class CDGL_IDirect3DBaseTexture9 : public IDirect3DBaseTexture9
{
	public:
		
		CDGL_IDirect3DBaseTexture9(IDirect3DDevice9 *pDevice);
		~CDGL_IDirect3DBaseTexture9();
		
		//! IUnknown methods
		HRESULT QueryInterface(REFIID, void **ppvObj);
		ULONG AddRef();
		ULONG Release();
		
		//! IDirect3DResource9 methods
		DWORD GetPriority();
		HRESULT GetPrivateData(REFGUID refguid, void *pData, DWORD *pSizeOfData);
		D3DRESOURCETYPE GetType();
		void PreLoad();
		DWORD SetPriority(DWORD PriorityNew);
		HRESULT SetPrivateData(REFGUID refguid, CONST void *pData, DWORD SizeOfData, DWORD Flags);
		HRESULT FreePrivateData(REFGUID refguid);
		HRESULT GetDevice(IDirect3DDevice9 **ppDevice);
		
		//! IDirect3DBaseTexture9 methods
		DWORD GetLevelCount();
		DWORD GetLOD();
		DWORD SetLOD(DWORD Lodnew);
		HRESULT SetAutoGenFilterType( D3DTEXTUREFILTERTYPE FilterType);
		D3DTEXTUREFILTERTYPE GetAutoGenFilterType();
		void GenerateMipSubLevels();
			
	protected:
	
		//! Member variables
		IDirect3DDevice9	*	m_pDevice;
		int						m_lRefCount;
};

#endif


